IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'PRC_FILIAL_TRANSF_DEMANDA') 
					AND type in (N'U')) 
BEGIN
CREATE TABLE [dbo].[PRC_FILIAL_TRANSF_DEMANDA](
	[TIPO_OPERACAO] [int] NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_FILIAL_DEMANDA] [int] NOT NULL,
 CONSTRAINT [PK_PRC_FILIAL_TRANSF_DEMANDA] PRIMARY KEY CLUSTERED 
(
	[TIPO_OPERACAO] ASC,
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_FILIAL_DEMANDA] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY],
 CONSTRAINT [IX_PRC_FILIAL_TRANSF_DEMANDA] UNIQUE NONCLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[TIPO_OPERACAO] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[PRC_FILIAL_TRANSF_DEMANDA] ADD  CONSTRAINT [DF_PRC_FILIAL_TRANSF_DEMANDA_TIPO_OPERACAO]  DEFAULT ((0)) FOR [TIPO_OPERACAO]

ALTER TABLE [dbo].[PRC_FILIAL_TRANSF_DEMANDA] ADD  CONSTRAINT [DF_PRC_FILIAL_TRANSF_DEMANDA_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[PRC_FILIAL_TRANSF_DEMANDA] ADD  CONSTRAINT [DF_PRC_FILIAL_TRANSF_DEMANDA_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[PRC_FILIAL_TRANSF_DEMANDA]  WITH CHECK ADD  CONSTRAINT [FK_PRC_FILIAL_TRANSF_DEMANDA_GLB_TIPO_OPERACAO] FOREIGN KEY([TIPO_OPERACAO])
REFERENCES [dbo].[GLB_TIPO_OPERACAO] ([TIPO_OPERACAO])

ALTER TABLE [dbo].[PRC_FILIAL_TRANSF_DEMANDA] CHECK CONSTRAINT [FK_PRC_FILIAL_TRANSF_DEMANDA_GLB_TIPO_OPERACAO]
end

